package editor;

import game.CustomImageDataII;
import game.IntRect;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.ImageObserver;
import java.io.BufferedWriter;

public class HeartScreenObject extends ScreenObject implements CloneableScreenObject {
	
	private IntRect clickRect;
	
	private boolean isSelected;
	
	public static final int HEART_WIDTH_AND_HEIGHT = 25;
	private CustomImageDataII image;
	
	public HeartScreenObject(int x, int y, ImageObserver io) {
		
		int clickRectMinX = x - HEART_WIDTH_AND_HEIGHT / 2;
		int clickRectMinY = y - HEART_WIDTH_AND_HEIGHT / 2;
		
		clickRect = new IntRect(clickRectMinX, clickRectMinY, HEART_WIDTH_AND_HEIGHT, HEART_WIDTH_AND_HEIGHT);
		
		image = new CustomImageDataII("/images/fullHeart.GIF", Color.WHITE, io);
		
		
	}
	
	
	@Override
	public void draw(Graphics g) {
		
		image.drawObjectFromUpperLeftCorner(g, clickRect.getMinX(), clickRect.getMinY());
		if(isSelected)
			drawSelectionOverObject(g);
	}

	@Override
	public IntRect getClickRect() {
		return clickRect;
	}

	public boolean isSelected() {
		return isSelected;
	}

	public void setSelected(boolean isSelected) {
		this.isSelected = isSelected;
	}


	@Override
	public void setClickRect(IntRect newRect) {
		// TODO Auto-generated method stub
		
	}
	
	public void writeDoorOutToFile(BufferedWriter out) throws Exception {
		
		out.write("item:");
		out.newLine();
		
		Point centerPoint = getClickRect().getCenter();
		
		out.write("x:");
		out.write(Integer.toString(centerPoint.x));
		out.newLine();
		
		out.write("y:");
		out.write(Integer.toString(centerPoint.y));
		out.newLine();
		
		out.write("heart");
		out.newLine();
		
		out.write("/item");
		out.newLine();
		
		out.newLine();
		
	}
	
	
	public HeartScreenObject clone(ImageObserver io) {
		
		Point centerPoint = getClickRect().getCenter();
		
		HeartScreenObject returnValue = new HeartScreenObject(centerPoint.x, centerPoint.y, io);
		
		return returnValue;
		
	}
	
	@Override
	public int getLayer() {
		
		return 15;
	}

}
